
class Ressource

  EXIST_FALSE = 0
  EXIST_DIR = 1
  EXIST_DIR_SEVERAL = 2
  EXIST_RTP = 3
  EXIST_RTP_SEVERAL = 4

  @@rtp = "RTP"

  attr_accessor :file_name
  attr_accessor :directory

  def initialize(file_name, directory)
    @file_name = file_name
    @directory = directory
    @places = []
  end
  
  def path
    return File.join(@directory, @file_name)
  end

  def real_path
    list = find_real_dir
    path = list[0]
    return path
  end
    
  def real_name
    real = real_path
    if real == nil
      return @file_name
    end
    list = real.split("/")
    return list.last
  end
    
  def find_real(path_dir)
    path = File.join(path_dir, @directory, @file_name+"*")
    p path
    list = Dir[path]
    return list
  end
    
  def find_real_dir
    return find_real("./")
  end
    
  def find_real_rtp
    return find_real(@@rtp)
  end
    
  def test_exist
    list_dir = find_real_dir
    list_rtp = find_real_rtp
    if list_dir.size == 0 and list_rtp.size == 0
      return EXIST_FALSE
    elsif list_dir.size == 1
      return EXIST_DIR
    elsif list_dir.size > 1
      # Plusieurs solution
      return EXIST_DIR_SEVERAL
    elsif list_rtp.size == 1
      return EXIST_RTP
    elsif list_rtp.size > 1
      return EXIST_RTP_SEVERAL
    end
  end
    
  # Ajoute une localisation  la ressource (commande)
  def add_place(place)
    @places << place
  end

  def lieux
    t = []
    t << "Map 3, Event 2, Page 1, Pos 2"
    t << "Map 6, Event 4, Page 2, Pos 1"
    return t
    
    arr = []
    for place in @places
      arr << place.position
    end
    return arr
  end

end

